% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_mease.R
\name{gen_mease}
\alias{gen_mease}
\title{Generate data from the Mease model}
\usage{
gen_mease(n = 1000, nsim = 1)
}
\arguments{
\item{n}{Integer specifying the number of observations. Default is 
\code{1000}.}

\item{nsim}{Integer specifying the number of binary repsonses to generate.
Default is \code{1}.}
}
\value{
A data frame with \code{3 + nsim} columns. The first two columns 
give the values of the numeric features \code{x1} and \code{x2}. The third
column (\code{yprob}) gives the true probabilities (i.e., Pr{Y = 1 | X = x}). 
The remaining \code{nsim} columns (\code{yclass<i>}, 
\code{i = 1, 2, ..., nsim}) give the simulated binary outcomes corresponding 
to \code{yprob}.
}
\description{
Generate binary classification data from the Mease model Mease et al. (2007).
}
\examples{
# Generate N = 1000 observations from the Mease model
set.seed(2254)  # for reproducibility 
mease <- gen_mease(1000, nsim = 1)

# Plot predictor values colored by binary outcome
cols <- palette.colors(2, palette = "Okabe-Ito", alpha = 0.3)
plot(x2 ~ x1, data = mease, col = cols[mease$yclass1 + 1], pch = 19)
}
\references{
Mease D, Wyner AJ, Buja A. Boosted classification trees and class probability
quantile estimation. Journal of Machine Learning Research. 2007; 8:409–439.
}
