% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_treemap_text.R
\name{geom_treemap_text}
\alias{geom_treemap_text}
\title{A 'ggplot2' geom to add text labels to treemap tiles.}
\usage{
geom_treemap_text(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  padding.x = grid::unit(1, "mm"),
  padding.y = grid::unit(1, "mm"),
  place = "topleft",
  min.size = 4,
  grow = FALSE,
  reflow = FALSE,
  fixed = NULL,
  layout = "squarified",
  start = "bottomleft",
  ...
)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{Standard
geom arguments as for \code{ggplot2::geom_text()}.}

\item{padding.x, padding.y}{\code{grid::unit()} object, giving horizontal or
vertical padding between text and edge of tile. Defaults to 1 mm.}

\item{place}{Where inside the box to place the text. Default is 'bottom';
other options are 'topleft', 'top', 'topright', etc.}

\item{min.size}{Minimum font size, in points. If provided, text that would
need to be shrunk below this size to fit the box will not be drawn. Defaults
to 4 pt.}

\item{grow}{If \code{TRUE}, text will be grown as well as shrunk to fill the box.}

\item{reflow}{If \code{TRUE}, text will be reflowed (wrapped) to better fit the
box.}

\item{fixed}{Deprecated. Use \code{layout = "fixed"} instead. Will be removed in
later versions.}

\item{layout}{The layout algorithm, one of either 'squarified' (the
default), 'scol', 'srow' or 'fixed'. See Details for full details on the
different layout algorithms.}

\item{start}{The corner in which to start placing the tiles. One of
'bottomleft' (the default), 'topleft', 'topright' or 'bottomright'.}
}
\description{
\code{geom_treemap_text()} can be used to add a text label to each tile in a
treemap created with \code{geom_treemap()}.
}
\details{
\code{geom_treemap_text()} requires \code{area} and \code{label} aesthetics. Several other
standard 'ggplot2' aesthetics are supported (see Aesthetics).

\code{geom_treemap_text()} uses the 'ggfittext' package to fit text to tiles. All
text drawing options available in \code{ggfittext::geom_fit_text()} (growing,
reflowing, etc.) are also available here. For full details on how these
options work, see the documentation for \code{ggfittext::geom_fit_text()}.

The \code{layout} argument is used to set the treemap layout algorithm. All
'treemapify' geoms added to a plot should have the same value for \code{layout}
and \code{start}, or they will not share a common layout (see \code{geom_treemap()}
for details on the layout algorithms).
}
\section{Aesthetics}{

\itemize{
\item area (required)
\item label (required)
\item subgroup, subgroup2 or subgroup3
\item colour
\item size
\item alpha
\item family
\item fontface
\item angle
}
}

\examples{

ggplot2::ggplot(G20, ggplot2::aes(area = gdp_mil_usd,
                                  fill = econ_classification,
                                  label = country)) +
  geom_treemap() +
  geom_treemap_text()

}
\seealso{
\code{\link[=geom_treemap]{geom_treemap()}}
}
