% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-methods.R
\name{setNdID}
\alias{setNdID}
\title{Set the ID of a node}
\usage{
setNdID(tree, id, val)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{id}{id to be changed}

\item{val}{new id}
}
\description{
Return a tree with the ID of a node altered.
}
\details{
IDs cannot be changed directly for the \code{TreeMan} class. To change an
ID use this function. Warning: all IDs must be unique, avoid spaces in IDs and only
use letters, numbers and underscores.
Use \code{\link{updateSlts}} after running.
}
\examples{
library(treeman)
tree <- randTree(10)
tree <- setNdID(tree, 't1', 'heffalump')
tree <- updateSlts(tree)
}
\seealso{
\code{\link{setNdsID}}
\url{https://github.com/DomBennett/treeman/wiki/set-methods}
}
