% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nds-methods.R
\name{getSpnsAge}
\alias{getSpnsAge}
\title{Get age ranges for multiple nodes}
\usage{
getSpnsAge(tree, ids, tree_age, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{tree_age}{numeric value of known age of tree}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Return start and end ages for \code{ids} from
when they first appear to when they split
}
\details{
Returns a dataframe, parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
# all nodes but root
ids <- tree['nds'][tree['nds'] != tree['root']]
getSpnsAge(tree, ids=ids, tree_age=getAge(tree))
}
\seealso{
\code{\link{getNdAge}}, 
\code{\link{getNdsAge}}, 
\code{\link{getSpnAge}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
