% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_cophylo_summary_stat.R
\name{cophy_summary_stat_by_indx}
\alias{cophy_summary_stat_by_indx}
\alias{summarize_1cophy}
\alias{cophy_summary_stat}
\alias{summarize_cophy}
\title{Calculates summary statistics for cophylogenetic objects}
\usage{
cophy_summary_stat_by_indx(cophy_obj, cophy_obj_indx)

summarize_1cophy(cophy_obj, cophy_obj_indx)

cophy_summary_stat(cophy_obj)

summarize_cophy(cophy_obj)
}
\arguments{
\item{cophy_obj}{The cophylogenetic object produced via `sim_cophyBD`}

\item{cophy_obj_indx}{The index with `cophy_obj` for `summarize_1cophy`}
}
\value{
A vector consisting of (in order) cospeciations, host speciations, host extinctions, symbiont speciations, symbiont extinctions, host spread/switch speciations, symbiont dispersals, symbiont extirpations, parafit statistic, and parafit p-value

A dataframe containing statistics relevant to cophylogenetic analysis
}
\description{
For cophylogenetic objects produced in treeducken via `sim_cophyBD`, calculates the numbers of different events of interest. In addition, calculates and tests the ParaFit test.
}
\section{Functions}{
\itemize{
\item \code{cophy_summary_stat_by_indx}: Calculates the summary statistics for one index of the list of cophylogenetic objects
}}

\examples{
host_mu <- 0.5 # death rate
host_lambda <- 2.0 # birth rate
numb_replicates <- 1
time <- 1.0
symb_mu <- 0.2
symb_lambda <- 0.4
host_shift_rate <- 0.0
cosp_rate <- 2.0

cophy_pair <- sim_cophyBD(hbr = host_lambda,
                           hdr = host_mu,
                           cosp_rate = cosp_rate,
                           host_exp_rate = host_shift_rate,
                           sdr = symb_mu,
                           sbr = symb_lambda,
                           numbsim = numb_replicates,
                           time_to_sim = time)
summary_stats <- summarize_cophy(cophy_pair)
}
