% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_cophylo.R
\name{host_tree}
\alias{host_tree}
\alias{host_tree.cophy}
\alias{host_tree.multiCophy}
\alias{symb_tree}
\alias{symb_tree.cophy}
\alias{symb_tree.multiCophy}
\alias{association_mat}
\alias{association_mat.cophy}
\alias{association_mat.multiCophy}
\alias{event_history.multiCophy}
\alias{print.cophy}
\alias{print.multiCophy}
\title{Print a cophylogenetic set}
\usage{
host_tree(cophy)

\method{host_tree}{cophy}(cophy)

\method{host_tree}{multiCophy}(cophy)

symb_tree(cophy)

\method{symb_tree}{cophy}(cophy)

\method{symb_tree}{multiCophy}(cophy)

association_mat(cophy)

\method{association_mat}{cophy}(cophy)

\method{association_mat}{multiCophy}(cophy)

\method{event_history}{multiCophy}(cophy)

\method{print}{cophy}(x, ...)

\method{print}{multiCophy}(x, details = FALSE, ...)
}
\arguments{
\item{cophy}{An object of class `cophy`}

\item{x}{An object of class `cophy` or class `multiCophy`}

\item{...}{Further arguments used in generic classes}

\item{details}{A logical value, outputs brief summary of each
set in the list.}
}
\value{
Print returns NULL. host_tree returns NULL, symb_tree returns NULL,
association_mat returns the dimensions of the matrix, event_history
 returns NULL.
}
\description{
Prints a cophylogenetic set or a list of cophylogenetic sets.
}
\section{Functions}{
\itemize{
\item \code{host_tree}: Returns host tree of a cophylogenetic set

\item \code{host_tree.cophy}: Returns host tree  of a cophylogenetic set

\item \code{host_tree.multiCophy}: Returns host tree of each member of a list
of cophylogenetic sets

\item \code{symb_tree}: Returns symb tree of a cophylogenetic set

\item \code{symb_tree.cophy}: Returns symb tree of a cophylogenetic set

\item \code{symb_tree.multiCophy}: Returns symb tree of each member of a
list of cophylogenetic sets

\item \code{association_mat}: Returns association matrix of a cophylogenetic set

\item \code{association_mat.cophy}: Returns association matrix of a cophylogenetic set

\item \code{association_mat.multiCophy}: Returns association matrix for each member of a
list of cophylogenetic sets

\item \code{event_history.multiCophy}: Returns event_history for each member of a list
of cophylogenetic sets

\item \code{print.multiCophy}: Prints a list of cophylogenetic sets
}}

\examples{
h_lambda <- 1.0
h_mu <- 0.3
c_lambda <- 0.0
s_lambda <- 1.0
s_mu <- 0.3
s_her <- 0.0
host_symb_sets <- sim_cophylo_bdp(hbr = h_lambda,
                                  hdr = h_mu,
                                  sbr = s_lambda,
                                  cosp_rate = c_lambda,
                                  sdr = s_mu,
                                  host_exp_rate = s_her,
                                  time_to_sim = 1.0,
                                  numbsim = 4)
print(host_symb_sets[[1]])
host_tree(host_symb_sets[[1]])
symb_tree(host_symb_sets[[1]])
association_mat(host_symb_sets[[1]])
event_history(host_symb_sets[[1]])
print(host_symb_sets)
}
\seealso{
sim_cophylo_bdp, print for the generic, multiCophy, c.cophy
}
\author{
Wade Dismukes, Ben Bolker, and Emmanuel Paradis
}
