% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_historical_assoc_mat.R
\name{build_historical_association_matrix}
\alias{build_historical_association_matrix}
\title{Reconstruct historical association matrix}
\usage{
build_historical_association_matrix(t, tr_pair_obj)
}
\arguments{
\item{t}{The time of interest}

\item{tr_pair_obj}{The tree pair object from `sim_cophylo_bdp`}
}
\value{
Matrix of the associations at given time
}
\description{
Reconstruct historical association matrix
}
\details{
Given a time and a tree pair object produced by the `sim_cophylo_bdp`
    object will produce the association matrix at that time point for the
    tree object.
USER WARNING: this is still in development, and likely will not work all the time.
}
\examples{
host_mu <- 1.0 # death rate
host_lambda <- 2.0 # birth rate
numb_replicates <- 1
time <- 1.0
symb_mu <- 0.2
symb_lambda <- 0.4
host_shift_rate <- 0.0
cosp_rate <- 2.0

cophylo_pair <- sim_cophylo_bdp(hbr = host_lambda,
                           hdr = host_mu,
                           cosp_rate = cosp_rate,
                           host_exp_rate = host_shift_rate,
                           sdr = symb_mu,
                           sbr = symb_lambda,
                           numbsim = numb_replicates,
                           time_to_sim = time)
time <- 1.0
assoc_mat_at_t <- build_historical_association_matrix(t=time, tr_pair_obj = cophylo_pair[[1]])


}
