% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxDepth.R
\name{maxDepth}
\alias{maxDepth}
\title{Calculation of the maximal depth of the tree}
\usage{
maxDepth(tree)
}
\arguments{
\item{tree}{A rooted tree in phylo format.}
}
\value{
\code{maxDepth} returns the maximal depth, i.e. height, of a tree.
}
\description{
This function calculates the maximal depth of any vertex in a rooted tree \eqn{T}, which
is at the same time its height \eqn{h(T)}. The tree must not necessarily be binary. Formally,
\eqn{h(T)} is defined as \deqn{h(T)=\max_{v\in V(T)} \delta(v)}{h(T)=max_{v in V(T)} depth(v)}
with \eqn{\delta(v)}{depth(v)} being the depth of the vertex \eqn{v}.
The maximal depth is an imbalance index.\cr\cr
For \eqn{n=1} the function returns \eqn{h(T)=0} and a warning.
}
\examples{
tree <- ape::read.tree(text="((((,),),(,)),(((,),),(,)));")
maxDepth(tree)
tree <- ape::read.tree(text="((,),((((,),),),(,)));")
maxDepth(tree)

}
\references{
C. Colijn and J. Gardy.  Phylogenetic tree shapes resolve disease transmission patterns. Evolution, Medicine, and Public Health, 2014(1):96-108, 2014. ISSN 2050-6201. doi: 10.1093/emph/eou018.
}
\author{
Luise Kuehn, Sophie Kersting
}
