% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tree_plot_area.R
\name{plot_tree_plot_area}
\alias{plot_tree_plot_area}
\title{Plot a Single Tree}
\usage{
plot_tree_plot_area(
  angle_counts,
  boundaries,
  tnr,
  enr,
  bnr,
  frame_factor = 4,
  use_sub = TRUE
)
}
\arguments{
\item{angle_counts}{A \code{\link{data.frame}} containing angle counts.
It has to have columns named by the contents of
either\cr
\code{\link{get_defaults}()[["angle_counts"]]} or \cr
\code{getOption("treePlotArea")[["angle_counts"]]}.\cr
Could be
\code{bw2bwi2022de(get(data("trees", package = "treePlotArea")))}).}

\item{boundaries}{A \code{\link{data.frame}} containing boundaries.
It has to have columns named by the contents of
either\cr
\code{\link{get_defaults}()[["boundaries"]]} or \cr
\code{getOption("treePlotArea")[["boundaries"]]}.\cr
Could be
\code{get(data("boundaries", package = "treePlotArea"))} or the
output of
\code{\link{get_boundary_polygons}}.}

\item{tnr}{Number of the tract.}

\item{enr}{Number of the tract's corner.}

\item{bnr}{Number of the corner's tree.}

\item{frame_factor}{Plotting from as a factor of the tree plot area. Stick
with the default.}

\item{use_sub}{Use the subtitle (or leave it blank)? Stick with the default.}
}
\value{
The corrections factor for the tree's plot area
}
\description{
Visualize a tree, it's plot area and its corner's boundaries.
}
\examples{
tnr <- 166
enr <- 2
bnr <- 7
angle_counts <- bw2bwi2022de(get(data("trees", package = "treePlotArea")))
plot_tree_plot_area(angle_counts = angle_counts,
                    boundaries = get(data("boundaries",
                                          package = "treePlotArea")),
                    tnr =  tnr, enr = enr, bnr = bnr, frame_factor = 4)
}
