% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_it_normal.R
\name{is_it_normal}
\alias{is_it_normal}
\title{Exploratory Data Analysis, Normality Testing, and
Visualization}
\usage{
is_it_normal(
  df,
  ...,
  group_vars = NULL,
  seed = 10232015,
  normality_test = NULL,
  include_plots = FALSE,
  plot_theme = traumar::theme_cleaner
)
}
\arguments{
\item{df}{A \code{data.frame} or \code{tibble} containing the variables to assess.}

\item{...}{One or more unquoted column names from \code{df} to be analyzed.}

\item{group_vars}{Optional. A character vector of column names in \code{df} to
group results by (e.g., \code{c("year", "hospital_level")}). If \code{NULL}, no
grouping is applied. Grouped summaries and normality tests are computed
within each unique combination of values across these variables.}

\item{seed}{A numeric value passed to \code{set.seed()} to ensure reproducibility.
Default is \code{10232015}.}

\item{normality_test}{A character string specifying the statistical test to
use. Must be one of: \verb{"shapiro-wilk" or "shapiro" or "sw"},
\verb{"kolmogorov-smirnov" or "ks"}, \verb{"anderson-darling" or "ad"}, \verb{"lilliefors" or "lilli"}, \verb{"cramer-von-mises" or "cvm"}, \verb{"pearson" or "p"}, or
\verb{"shapiro-francia" or "sf"}. If \code{NULL}, no normality test is performed,
which is the default.}

\item{include_plots}{Logical. If \code{TRUE}, plots are generated for a single
variable. Plotting is disabled if multiple variables are passed.}

\item{plot_theme}{A \code{ggplot2::theme} function to apply to all plots. Default
is \code{traumar::theme_cleaner}.}
}
\value{
A named list with the following elements:
\describe{
\item{descriptive_statistics}{A \code{tibble} of summary statistics for each
variable.}
\item{normality_test}{A \code{tibble} of test statistics and p-values
(if \code{normality_test == TRUE}).}
\item{plots}{A patchwork object containing four plots (if \code{include_plots = TRUE} and one variable supplied).}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{is_it_normal()} calculates descriptive statistics and conducts univariate
normality testing on one or more numeric variables in a dataset using a
selected statistical test. Optional plots are included for one variable at a
time, only. Results are returned as a named list containing summaries and,
optionally, normality tests and/or diagnostic plots.
}
\details{
\itemize{
\item If the data do not meet the test requirements for a chosen test of
normality, \code{is_it_normal()} will not run the tests.
\item Normality tests may yield differing results. Each test has distinct
assumptions and sensitivity. Users should verify assumptions and consult
test-specific guidance to ensure appropriate use.
\item The function will abort with helpful CLI messages if input types or
structures are incorrect.
\item If plotting is enabled, and \code{nrow(df) > 10000}, a warning is issued
as plotting may become computationally expensive.
}
}
\note{
Supported normality tests are below. Please check the specifications of
these tests in the corresponding documentation.
\itemize{
\item Shapiro-Wilk (\code{stats::shapiro.test()})
\item Kolmogorov-Smirnov (\code{stats::ks.test()})
\item Anderson-Darling (\code{nortest::ad.test()})
\item Lilliefors (\code{nortest::lillie.test()})
\item Cramer-von Mises (\code{nortest::cvm.test()})
\item Pearson (\code{norest::pearson.test()})
\item Shapiro-Francia (\code{nortest::sf.test()})
}

Please note that if grouped plotting is enabled, each group will generate its
own set of plots. This may flood your IDE or console. Plan your use of this
functionality with care to avoid lags or unwanted outputs.
}
\author{
Nicolas Foss, Ed.D., MS
}
