% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{simulate}
\alias{simulate}
\title{Simulation (reproducibility)}
\usage{
simulate(
  p = 1000,
  n.target = 100,
  n.source = 150,
  k = 2,
  family = "gaussian",
  prop = 0.01,
  rho.beta = 0.95,
  rho.x = 0.95,
  w = 0.5,
  trans = rep(TRUE, times = k),
  exp = rep(1, times = k)
)
}
\arguments{
\item{p}{number of features}

\item{n.target}{sample size for target data set}

\item{n.source}{sample size(s) for source data set(s), scalar or vector of length k}

\item{k}{number of source data sets}

\item{family}{"Gaussian", "binomial" or "poisson"}

\item{prop}{approximate proportion of features with effects}

\item{rho.beta}{correlation between effects (across different data sets)}

\item{rho.x}{base for decreasing correlation structure for correlation between features}

\item{w}{weight between signal and noise}

\item{trans}{logical vector of length \eqn{k}:
transferable (TRUE) or non-transferable (FALSE) source}

\item{exp}{non-negative vector of length \eqn{k}
for transforming beta to sign(beta)*abs(beta)^exp}
}
\description{
Function for reproducing 'internal' simulation study.
See vignette.
}
\seealso{
Use [glmtrans::models()] for reproducing 'external' simulation study.
}
