% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssCorrelations.R
\name{xpssCorrelations}
\alias{xpssCorrelations}
\title{Pearson product-moment correlations}
\usage{
xpssCorrelations(x,
               variables = NULL,
               miss = list(alternative = "pairwise",
                         missings = "exclude"),
               print = list(test = "twotail",
                       level = "sig"),
               matrix = NULL,
               statistics = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class "xpss-Frame".}

\item{variables}{atomic character or character vektor with the name of the variables.}

\item{miss}{method which indicates what should happen when the data contain NAs. Default for alternative is 'pairwise', optionally listwise can be used as treatment for missings. The visualisation of the NAs can be specied via the argument missings. Default is 'exclude', optionally 'include' can be chosen to add missings in the statistics.}

\item{print}{method which indicates what significnace level shall be used. Default significance test is 'twotail', optionally 'onetail' can be chosen. Default significance level is 'sig' to add significance asterisks, optionally 'nosig'.}

\item{matrix}{exports the correlation matrix with observations, stddevs, means and variable names. Default is NULL.}

\item{statistics}{method which enumerate the deskriptive statistics. Default is NULL. Optionally 'descriptives', 'xprod' or 'all' can be chosen.}
}
\value{
Returns a matrix of Pearson's r correlation.
}
\description{
R implementation of the SPSS \code{CORRELATIONS} function.
}
\details{
\code{xpssCorrelations} produces Pearson product-moment correlations with significance levels and, optionally, univariate statistics, covariances, and cross-product deviations.
}
\examples{
data(fromXPSS)



xpssCorrelations (fromXPSS,
                 variables =c("V5","V6","V7_2"))



xpssCorrelations (fromXPSS,
                 variables =c("V5","V6","V7_2") ,
                 miss = list(alternative = "pairwise",
                                missings = "exclude"),
                 print = list(test = "onetail",
                              level = "sig"),
                 statistics="all")



xpssCorrelations (fromXPSS,
                 variables =c("V5","V6","V7_2") ,
                 miss = list(alternative = "pairwise",
                                missings = "include"),
                 print = list(test = "onetail",
                              level = "sig"),
                 statistics="all")



xpssCorrelations (fromXPSS,
                 variables =c("V5","V6","V7_2") ,
                 miss = list(alternative = "listwise",
                                missings = "exclude"),
                 print = list(test = "twotail",
                              level = "sig"),
                 statistics="all")



xpssCorrelations (fromXPSS,
                 variables =c("V5","V6","V7_2"),
                 statistics = "all",
                 matrix = paste0(getwd(),"/correlations.txt"))
}
\author{
Benjamin Piest
}
\seealso{
\code{\link{cor}} \code{\link{cor.test}} \code{\link{rcorr}}
}

