% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeMissings.R
\name{computeValue}
\alias{computeValue}
\title{Displays the value of the variable cases.}
\usage{
computeValue(x, variables = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame, data.table object or input data of class "xpssFrame".}

\item{variables}{atomic character or character vector with the names of the variables.}
}
\value{
A "xpssFrame" object or (data frame) with implemented user-defined missing values.

\strong{NOTE:} The whole dataset gets returned!
}
\description{
R implementation of the SPSS \code{Value} function.
}
\details{
Performs a missing value operation. Adds the user-defined missing values of the variables in the existing dataset.

\code{variables} variables have to be same type.
}
\examples{
data(fromXPSS)

xpssCompute(x = fromXPSS, variables="V7_2", fun="computeValue")
xpssCompute(x = fromXPSS, variables="V7_2", fun="computeValue")
}
\author{
Bastian Wiessner
}
\seealso{
Related Functions \code{\link{computeMiss}} , \code{\link{computeNmiss}} , \code{\link{computeNvalid}} , \code{\link{computeSysmis}}
}
\keyword{internal}

