% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssLag.R
\name{computeLag}
\alias{computeLag}
\title{Moves cases of variables}
\usage{
computeLag(x, move = 0, value = NA)
}
\arguments{
\item{x}{a (non-empty) data.frame, data.table object or input data of class "xpssFrame".}

\item{move}{atomic integer, either positive or negative that defines the cases to move. The algebraic sign indicates the direction.}

\item{value}{atomic numeric or atomic character value that replaces the skipped cases.}
}
\value{
Output is the shifted, respectively "lagged" input vector. \cr Length of the new lagged vector is identical with the length of the input vector.
}
\description{
computeLag shifts the dataset forward or backward by a given number of observations.
}
\details{
Creates shifted data dependent upon the direction in which the data got moved. \cr A positive indicator refers a shift to the right side, a negative indicator refers a shift of the data to the left side. Empty cases get filled with NA.
}
\examples{
data(fromXPSS)
computeLag(x=fromXPSS$V6, move = 2, value = NA)
}
\author{
Andreas Wygrabek
}
\keyword{internal}

