% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeDates.R
\name{computeDate_qyr}
\alias{computeDate_qyr}
\title{Creates a date with the format year/quarter}
\usage{
computeDate_qyr(day=NULL,month=NULL, year= NULL)
}
\arguments{
\item{day}{atomic numeric or integer.}

\item{month}{atomic numeric or integer.}

\item{year}{atomic numeric or integer.}
}
\value{
Returns a atomic character of the structure year / quarter.
}
\description{
R Implementation of the SPSS \code{DATE.QYR} Function. \code{computeDate_qyr} is a helper function for xpssCompute.
}
\details{
An character string as Date. Returns a date value corresponding to the indicated month, and year. The arguments must resolve to integers or numerics, with day between 1 and 31, month between 1 and 12, and year a four-digit integer value.
}
\examples{
xpssCompute(x=5, fun="computeDate_qyr", month=10, year=2006)
xpssCompute(x=10, fun="computeDate_qyr", month=1, year=2010)
}
\author{
Bastian Wiessner
}
\seealso{
\code{\link{computeDate_wkyr}} \code{\link{computeDate_yrday}}
}
\keyword{internal}

