% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeDates.R
\name{computeCtime_minutes}
\alias{computeCtime_minutes}
\title{Calculates the difference between two dates in minutes}
\usage{
computeCtime_minutes(x,date)
}
\arguments{
\item{x}{atomic object of class \code{character, POSIXlt  or  POSIXt} holding date data}

\item{date}{atomic object of class \code{character, POSIXlt  or  POSIXt} holding date data}
}
\value{
Returns the difference between x and date in minutes.
}
\description{
R Implementation of the SPSS \code{CTIME.MINUTES} Function.\code{computeCtime_minutes} is a helper function for xpssCompute.
}
\details{
The input format of date's with timeparameter's is YYYY-MM-DD HH:MM:SS. All parameters are necessary to calculate the minute difference!
}
\examples{
xpssCompute(x="2013-09-14 12:12:12", fun="computeCtime_minutes", date="2013-09-14 10:10:10")
xpssCompute(x="2013-09-14 12:12:12", fun="computeCtime_minutes", date="2013-09-06 22:10:10")
}
\author{
Bastian Wiessner
}
\seealso{
\code{\link{difftime}} \code{\link{DateTimeClasses}} \code{\link{as.POSIXlt}} \code{\link{strptime}}
}
\keyword{internal}

