% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\name{model.matrix.tramME}
\alias{model.matrix.tramME}
\title{Model matrices for \code{tramME} models}
\usage{
\method{model.matrix}{tramME}(
  object,
  data = model.frame(object),
  type = c("Y", "X", "Zt"),
  drop_unused_groups = FALSE,
  keep_sign = TRUE,
  simplify = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{data}{A \code{data.frame} containing the variable values.}

\item{type}{"X": Fixed effects model matrix. "Zt": Random effects model matrix
(transposed). "Y": Model matrices for the baseline transfromations.}

\item{drop_unused_groups}{Logical; remove unused levels of the random effects.
(see \code{drop.unused.levels} argument of \code{\link[lme4]{mkReTrms}})}

\item{keep_sign}{Logical; the terms will have the same sign as in the
\code{tramME} model if \code{TRUE}.}

\item{simplify}{Logical; Remove empty \code{Y} matrices.}

\item{...}{Optional arguments.}
}
\value{
List of requested model matrices.
}
\description{
Model matrix for fixed effects, random effects, and baseline transformations
(with interacting terms if present).
}
\details{
Creates model matrices for fixed effects (\code{type = "X"}) and random
effects (\code{type = "Zt"}) and baseline transfromation (\code{type = "Y"}),
by evaluating the respective basis functions given a new dataset.

The response values may be exact, censored (left, right, interval) and
truncated (left, right, interval), and the function returns several,
potentially empty, model matrices:
  \itemize{
    \item Ye: Exact observations.
    \item Yeprime: The model matrix corresponding to the first derivative
          of the baseline transformation, evaluated at exact observations.
    \item Yl: Left-censored observations.
    \item Yr: Rigt-censored observations.
    \item Yil and Yir: Interval-censored observations evaluated at the
          left and right bounds of the interval.
    \item Ytl: Left-truncated observations.
    \item Ytr: Rigt-truncated observations.
    \item Ytil and Ytir: Interval-truncated observations evaluated at the
          left and right bounds of the interval.
  }
for the baseline transfromations (unless \code{simplify = TRUE}).
}
\note{
The model matrix of the random effects is a sparse matrix and it is transposed
  to be directly used with \code{Matrix::crossprod} which is faster than transposing
  and multiplying ("Zt" instead of "Z").
}
\examples{
library("survival")
rats$litter <- factor(rats$litter)
m <- CoxphME(Surv(time, status) ~ rx + (1 | litter), data = rats,
             log_first = TRUE, nofit = TRUE)
mm <- model.matrix(m)
nd <- model.frame(m)[rep(1, 100), ]
nd[[1]] <- seq(1, 120, length.out = 100)
mm2 <- model.matrix(m, data = nd, simplify = TRUE)
mm3 <- model.matrix(m, data = nd, simplify = TRUE, drop_unused_groups = TRUE)
## compare mm2$Zt & mm3$Zt
}
