% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.Trajectory}
\alias{plot.Trajectory}
\title{Plot method for trajectories}
\usage{
\method{plot}{Trajectory}(x, add = FALSE, draw.start.pt = TRUE,
  turning.angles = NULL, xlim = grDevices::extendrange(x$x),
  ylim = grDevices::extendrange(x$y),
  xlab = ifelse(is.null(TrajGetUnits(x)), "x", sprintf("x (\%s)",
  TrajGetUnits(x))), ylab = ifelse(is.null(TrajGetUnits(x)), "y",
  sprintf("y (\%s)", TrajGetUnits(x))), asp = 1, ...)
}
\arguments{
\item{x}{An object of class "Trajectory", the trajectory to be plotted.}

\item{add}{If TRUE, the trajectory is added to the current plot.}

\item{draw.start.pt}{If TRUE, draws a dot at the start point of the
trajectory.}

\item{turning.angles}{If \code{random} or \code{directed}, draws step turning
angles. \code{directed} assumes errors are relative to the first recorded
step angle. \code{random} assumes errors are relative to the previous step.}

\item{xlim, ylim, xlab, ylab, asp}{plotting parameters with useful defaults.}

\item{...}{Additional arguments are passed to \code{\link[graphics]{plot}}.}
}
\description{
The \code{plot} method for Trajectory objects.
}
\examples{
set.seed(42)
trj <- TrajGenerate(angularErrorSd = 1.3)
plot(trj)

}
\seealso{
\code{\link{TrajFromCoords}}
}
