% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajhrmsm_pltmle.R
\name{trajhrmsm_pltmle}
\alias{trajhrmsm_pltmle}
\title{History Restricted MSM and Latent Class of Growth Analysis estimated with a Pooled LTMLE.}
\usage{
trajhrmsm_pltmle(
  degree_traj = c("linear", "quadratic", "cubic"),
  treatment,
  covariates,
  baseline,
  outcome,
  ntimes_interval,
  total_followup,
  time,
  time_values,
  identifier,
  var_cov,
  number_traj = 3,
  family = "poisson",
  obsdata,
  treshold = 0.99
)
}
\arguments{
\item{degree_traj}{To specify the polynomial degree for modelling the time-varying treatment.}

\item{treatment}{Name of time-varying treatment.}

\item{covariates}{Names of time-varying covariates (should be a list).}

\item{baseline}{Names of baseline covariates.}

\item{outcome}{Name of the outcome variable.}

\item{ntimes_interval}{Length of a time-interval (s).}

\item{total_followup}{Total length of follow-up.}

\item{time}{Name of the time variable.}

\item{time_values}{Measuring times.}

\item{identifier}{Name of the column for unique identifiant.}

\item{var_cov}{Names of the time-varying variables.}

\item{number_traj}{Number of trajectory groups.}

\item{family}{Specification of the error distribution and link function to be used in the model.}

\item{obsdata}{Data in a long format.}

\item{treshold}{For weight truncation.}
}
\value{
A list containing the following components:
  \describe{
  \item{results_hrmsm_pltmle}{ Matrix of estimates for LCGA-HRMSM, obtained using the pooled ltlmle method.}
  \item{restraj}{ Fitted trajectory model.}
  \item{mean_adh}{ Matrix of the mean adherence per trajectory group.}
  }
}
\description{
Estimate parameters of LCGA-HRMSM using a Pooled LTMLE.
}
\examples{
\donttest{
obsdata_long = gendata(n = 5000, format = "long",
total_followup = 8, timedep_outcome = TRUE,  seed = 845)
baseline_var <- c("age","sex")
years <- 2011:2018
variables <- c("hyper", "bmi")
covariates <- lapply(years, function(year) {
  paste0(variables, year)})
treatment_var <- paste0("statins", 2011:2018)
var_cov <- c("statins","hyper", "bmi","y")
respltmle = trajhrmsm_pltmle(degree_traj = "linear", treatment = treatment_var,
covariates = covariates, baseline = baseline_var,
outcome = paste0("y", 2016:2018),var_cov = var_cov, ntimes_interval = 6,
total_followup = 8, time = "time",time_values = years, identifier = "id",
number_traj = 3, family = "poisson", obsdata = obsdata_long,treshold = 1)
respltmle$results_hrmsm_pltmle
}
}
\author{
Awa Diop Denis Talbot
}
