% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_adequacy.R
\name{OCC}
\alias{OCC}
\title{Odds of Correct Classification}
\usage{
OCC(sol, Y, A)
}
\arguments{
\item{sol}{Trajectory's object. An object of type Trajectory.}

\item{Y}{Matrix. A matrix containing the variables in the model.}

\item{A}{Matrix. A matrix containing the time variable data.}
}
\value{
A vector of reals. The Odds of Correct Classification.
}
\description{
Calculate Odds of Correct Classification. The Odds of Correct Classification for 
group k (OCCj) is the ratio between the odds of a correct 
classification into group j on the basis of the posterior probability rule and 
the odds of correct assignment based on random assignments with the probability 
of assignment to group j is done with $pi_{ik}$, the probability estimate by 
the model.
}
\examples{
data = read.csv(system.file("extdata", "CNORM2gr.csv", package = "trajeR"))
data = as.matrix(data)
sol = trajeR(Y = data[, 2:6], A = data[, 7:11], degre = c(2,2), Model = "CNORM", Method = "EM")
OCC(sol, Y = data[, 2:6], A = data[, 7:11])
}
