% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eol_invasive.R
\name{eol_invasive_}
\alias{eol_invasive_}
\title{Search for presence of taxonomic names in EOL invasive species databases.}
\usage{
eol_invasive_(name = NULL, dataset = "all", searchby = grep,
  page = NULL, per_page = NULL, key = NULL, verbose = TRUE,
  count = FALSE, ...)
}
\arguments{
\item{name}{A taxonomic name, or a vector of names.}

\item{dataset}{One of all, gisd100, gisd, isc, daisie, i3n, or mineps.
See the Details for what each dataset ID.}

\item{searchby}{One of 'grep' (exact match) or 'agrep' (fuzzy match)}

\item{page}{A maximum of 30 results are returned per page. This parameter allows
you to fetch more pages of results if there are more than 30 matches (Default 1)}

\item{per_page}{Results to get per page}

\item{key}{Your EOL API key; loads from .Rprofile.}

\item{verbose}{(logical) If TRUE the actual taxon queried is printed on the
console.}

\item{count}{(logical) If TRUE, give back a count of number of taxa listed as invasive, if
FALSE (default), the normal output is given.}

\item{...}{Further args passed on to \code{\link[httr]{GET}}}
}
\value{
A list of data.frame's/strings with results, with each element named by
the input elements to the name parameter.
}
\description{
See Details for important information.
}
\details{
IMPORTANT: When you get a returned NaN for a taxon, that means it's not on the invasive list
in question. If the taxon is found, a taxon identifier is returned.

Beware that some datasets are quite large, and may take 30 sec to a minute to
pull down all data before we can search for your species. Note there is no
parameter in this API method for searching by taxon name.

This function is vectorized, so you can pass a single name or a vector of names.

It's possible to return JSON or XML with the EOL API. However, this function only returns
JSON for now.

Options for the dataset parameter are
\itemize{
 \item all - All datasets
 \item gisd100 - 100 of the World's Worst Invasive Alien Species
 (Global Invasive Species Database) http://eol.org/collections/54500
 \item gisd - Global Invasive Species Database 2013 http://eol.org/collections/54983
 \item isc - Centre for Agriculture and Biosciences International Invasive Species
 Compendium (ISC) http://eol.org/collections/55180
 \item daisie - Delivering Alien Invasive Species Inventories for Europe (DAISIE) Species
 List http://eol.org/collections/55179
 \item i3n - IABIN Invasives Information Network (I3N) Species
 http://eol.org/collections/55176
 \item mineps - Marine Invaders of the NE Pacific Species http://eol.org/collections/55331
}

Datasets are not updated that often. Here's last updated dates for some of the datasets as of
2014-08-25

\itemize{
 \item gisd100 updated 6 mos ago
 \item gisd  updated 1 yr ago
 \item isc updated 1 yr ago
 \item daisie updated 1 yr ago
 \item i3n updated 1 yr ago
 \item mineps updated 1 yr ago
}
}
\examples{
\dontrun{
eol_invasive_(name='Brassica oleracea', dataset='gisd')
eol_invasive_(name=c('Lymantria dispar','Cygnus olor','Hydrilla verticillata','Pinus concolor'),
   dataset='gisd')
eol_invasive_(name='Sargassum', dataset='gisd')
eol_invasive_(name='Ciona intestinalis', dataset='mineps')
eol_invasive_(name=c('Lymantria dispar','Cygnus olor','Hydrilla verticillata','Pinus concolor'),
   dataset='i3n')
eol_invasive_(name=c('Branta canadensis','Gallus gallus','Myiopsitta monachus'),
   dataset='daisie')
eol_invasive_(name=c('Branta canadensis','Gallus gallus','Myiopsitta monachus'), dataset='isc')

# Count
eol_invasive_(name=c('Lymantria dispar','Cygnus olor','Hydrilla verticillata','Pinus concolor'),
   dataset='gisd', count = TRUE)
}
}
\references{
See info for each data source at \url{http://eol.org/collections/55367/taxa}
}

