% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_trafo.R
\name{trafo_compare}
\alias{trafo_compare}
\title{Compares linear models with transformed dependent variable}
\usage{
trafo_compare(object, trafos, std = FALSE)
}
\arguments{
\item{object}{an object of type lm}

\item{trafos}{a list of two \code{trafo} objects based on the same model 
given in object.}

\item{std}{logical. If \code{TRUE}, the transformed models are returned 
based on the standardized/scaled transformation. Defaults to \code{FALSE}.}
}
\value{
An object of class \code{trafo_compare}. Methods such as 
\code{\link{diagnostics.trafo_compare}}, \code{\link{print.trafo_compare}},
\code{\link{plot.trafo_compare}} and \code{\link{summary.trafo_compare}} can 
be used for this class.
}
\description{
Function \code{trafo_compare} compares linear models where the dependent 
variable is transformed by different transformations.
}
\examples{
# Load data
data("cars", package = "datasets")

# Fit linear model
lm_cars <- lm(dist ~ speed, data = cars)

# Transform with Bickel-Doksum transformation
bd_trafo <- bickeldoksum(object = lm_cars, plotit = FALSE)

# Transform with Box-Cox transformation
bc_trafo <- boxcox(object = lm_cars, method = "skew", plotit = FALSE)

# Compare transformed models
trafo_compare(object = lm_cars, trafos = list(bd_trafo, bc_trafo))
}
\seealso{
\code{\link{bickeldoksum}}, \code{\link{boxcox}}, \code{\link{dual}}, 
\code{\link{glog}}, \code{\link{gpower}}, \code{\link{log}}, 
\code{\link{logshiftopt}}, \code{\link{manly}}, \code{\link{modulus}}, 
\code{\link{neglog}}, \code{\link{sqrtshift}}, \code{\link{yeojohnson}}
}
