% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggwrite.R
\name{ggwrite}
\alias{ggwrite}
\title{Export plots created with ggplot (and more) or tables to files
(png or pdf) - or show them on screen.}
\usage{
ggwrite(
  plot,
  file,
  script,
  canvas = "standard",
  onefile = FALSE,
  res = 200,
  paper = "special",
  save = TRUE,
  show = !save,
  useNames = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{plot}{A plot object or a list of plots. Normally generated
with ggplot or qplot. But it can also be from grid.arrange or
arrangeGrob with class gtable. That is experimental
though. Not sure exactly what classes are supported.}

\item{file}{A file to export to. Must end in .png or .pdf. If plot
is a list, see onefile. If missing, plot is shown on screen.}

\item{script}{This should normally be the path to your
script. Requires ggplot >=2.2.1.}

\item{canvas}{Either a list of height and width or a shortname of
predefined canvas size. See ?canvasSize.}

\item{onefile}{Only applicable if plot is a list. If plot is a
list and onefile=TRUE, all plots will be put in a pdf (file must
end in pdf) with one plot per page. If plot is a list and
onefile=FALSE, numbered files will be created - one per list
element.}

\item{res}{Resolution. Passed to png.}

\item{paper}{Only used with pdf device. See ?pdf.}

\item{save}{Save the plot to the given file or just show? Defaults
to TRUE. Hint, if you use an "exportFlag", use
save=exportFlag.}

\item{show}{Print the plot to the screen? Defaults to the opposite
of save. Hint, combining save and show in knitr can give you
both a high quality plot in your pdf and a png optimized for
powerpoint.}

\item{useNames}{If length(plot)>1 use names(plot) in the file
names? Default is to use 1:length(plot). Only used if save is
TRUE, and length(plot)>1.}

\item{quiet}{Default is false but use TRUE to suppress messages about what was saved.}
}
\value{
Nothing. Files written and/or plots shown, depending on argument values.
}
\description{
Export plots created with ggplot (and more) or tables to files
(png or pdf) - or show them on screen.
}
\examples{
library(ggplot2)
writeOutput <- FALSE
data(ChickWeight)
p1 <- ggplot(ChickWeight,aes(Time,weight,group=Chick,colour=factor(Diet)))+geom_line()
ggwrite(p1)  ## view plot on screen
script <- "note"
ggwrite(p1,script=script,canvas="wide",file="myplot1.png",save=writeOutput)
## save a data.frame as an image
}
\seealso{
Other Plotting: 
\code{\link{canvasSize}()},
\code{\link{ggstamp}()},
\code{\link{ggwater}()}
}
\concept{Plotting}
