% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/podc.ci.R
\name{podc.ci}
\alias{podc.ci}
\title{Partial ODC Inference}
\usage{
podc.ci(response, predictor, cp = 0.95, threshold = 0.9, method = "MW")
}
\arguments{
\item{response}{a factor, numeric or character vector of responses; 
typically encoded with 0 (negative) and 1 (positive). 
Only two classes can be used in a ROC curve. If its levels are not 0 and 1,
the first level will be defaultly regarded as negative.}

\item{predictor}{a numeric vector of the same length than response, containing the predicted value of each observation. An ordered factor is coerced to a numeric.}

\item{cp}{numeric; coverage probability of confidence interval.}

\item{threshold}{numeric; false negative rate (FNR) constraint.}

\item{method}{methods to estimate partial ODC. \code{MW}: Mann-Whitney statistic. \code{expect}: method in \href{http://www3.stat.sinica.edu.tw/ss_newpaper/SS-13-367_na.pdf}{Yang et al., 2016} adapted from \href{http://www.ncbi.nlm.nih.gov/pubmed/20729218}{Wang and Chang, 2011}. \code{jackknife}: jackknife method in \href{http://www3.stat.sinica.edu.tw/ss_newpaper/SS-13-367_na.pdf}{Yang et al., 2016}.}
}
\value{
Confidence interval of FNR partial ODC.
}
\description{
Infer the area of region under ordinal dominance curve with pre-specific FNR constraint (FNR-pODC). See \href{http://www3.stat.sinica.edu.tw/ss_newpaper/SS-13-367_na.pdf}{Yang et al., 2016} for details.
}
\details{
This function infers FNR partial ODC given response, predictor and pre-specific FNR constraint. The plot of corresponding ODC curve with pre-specific FNR is generated.
         \code{MW}: Mann-Whitney statistic. \code{expect}: method in (2.2) \href{http://www.ncbi.nlm.nih.gov/pubmed/20729218}{Wang and Chang, 2011}. \code{jackknife}: jackknife method in \href{http://www3.stat.sinica.edu.tw/ss_newpaper/SS-13-367_na.pdf}{Yang et al., 2016}.
}
\examples{

library('pROC')
data(aSAH)
podc.ci(aSAH$outcome, aSAH$s100b, method='expect',threshold=0.8, cp=0.97)

}
\author{
Hanfang Yang, Kun Lu, Xiang Lyu, Feifang Hu.
}
\seealso{
\code{\link[tpAUC]{proc.ci}}
}

