% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{save_plot_pdf}
\alias{save_plot_pdf}
\title{save plots in pdf}
\usage{
save_plot_pdf(plot_list, filename)
}
\arguments{
\item{plot_list}{the r list object contains all ggplot2 objects}

\item{filename}{the output file name, including the file directory}
}
\description{
save ggplot2 plots generated in a list to a pdf file
}
\examples{
## start from raw data
# define assay
assay_info <- list(prim_assay = "Primary",toxi_assay = "Cytotox")
# data normalization
demo_mc_norm <- normalize_per_plate(demo_mc, nctrl = "DMSO")
# filter out two test chemicals
demo_mc_norm <- dplyr::filter(demo_mc_norm, spid \%in\% c("TP0001502B05", "TP0001502B01"))
# fit curve with default 20\% threshold
demo_md <- fit_curve_tcpl(demo_mc_norm, assay_info)
# calculate TAA and Med_diff only
demo_rank <- rank_tcpl(demo_md, med_taa = NULL, med_med_diff = NULL)
#produce plots with notations
demo_plots <- plot_tcpl_minimal(demo_md, demo_rank, notation = TRUE)

## save all the plots as pdf
# save_plot_pdf(demo_plots, ".\\output plots\\all_plots.pdf")

## save the 1st plot as pdf
# save_plot_pdf(demo_plots[1], ".\\output plots\\plot1.pdf")



}
