% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{insert_dot}
\alias{insert_dot}
\title{Insert Dot to ICD-9 and ICD-10 Diagnosis Codes}
\usage{
insert_dot(dx, version = c(10, 9))
}
\arguments{
\item{dx}{A character vector for the diagnosis codes}

\item{version}{The version of the diagnosis codes.  Two available options
are \code{10} and \code{9}.  The default version is \code{10} for
ICD-10.  This argument can be either a numerical value (nummerical
vector of length one) or a character string (character vector of
length one).}
}
\value{
A character vector representing the diagnosis codes in decimal
    format.
}
\description{
This function adds dot to diagnosis codes of the given ICD version.
}
\examples{
library(touch)

## for ICD-9 codes
icd9codes <- c("0011", "001.1", "316", "E950", "E9808", "V90", "v100")
insert_dot(icd9codes, 9)

## for ICD-10 codes
icd10codes <- c("A010", "M61019", "p52", "p528")
insert_dot(icd10codes)
}
