% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_dcshift}
\alias{functional_dcshift}
\title{DC Shift (functional)}
\usage{
functional_dcshift(waveform, shift, limiter_gain = NULL)
}
\arguments{
\item{waveform}{(Tensor): audio waveform of dimension of \verb{(..., time)}}

\item{shift}{(float): indicates the amount to shift the audio
Allowed range of values for shift : -2.0 to +2.0}

\item{limiter_gain}{(float): It is used only on peaks to prevent clipping
It should have a value much less than 1  (e.g. 0.05 or 0.02)}
}
\value{
\code{tensor}: Waveform of dimension of \verb{(..., time)}
}
\description{
Apply a DC shift to the audio. Similar to SoX implementation.
This can be useful to remove a DC offset (caused perhaps by a
hardware problem in the recording chain) from the audio
}
\references{
\itemize{
\item \url{https://sox.sourceforge.net/sox.html}
}
}
