% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_detect_pitch_frequency}
\alias{functional_detect_pitch_frequency}
\title{Detect Pitch Frequency (functional)}
\usage{
functional_detect_pitch_frequency(
  waveform,
  sample_rate,
  frame_time = 10^(-2),
  win_length = 30,
  freq_low = 85,
  freq_high = 3400
)
}
\arguments{
\item{waveform}{(Tensor): Tensor of audio of dimension (..., freq, time)}

\item{sample_rate}{(int): The sample rate of the waveform (Hz)}

\item{frame_time}{(float, optional): Duration of a frame (Default: \code{10 ** (-2)}).}

\item{win_length}{(int, optional): The window length for median smoothing (in number of frames) (Default: \code{30}).}

\item{freq_low}{(int, optional): Lowest frequency that can be detected (Hz) (Default: \code{85}).}

\item{freq_high}{(int, optional): Highest frequency that can be detected (Hz) (Default: \code{3400}).}
}
\value{
Tensor: Tensor of freq of dimension (..., frame)
}
\description{
It is implemented using normalized cross-correlation function and median smoothing.
}
