% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_cumsum}
\alias{torch_cumsum}
\title{Cumsum}
\usage{
torch_cumsum(self, dim, dtype = NULL)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim}{(int) the dimension to do the operation over}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned tensor.        If specified, the input tensor is casted to \code{dtype} before the operation        is performed. This is useful for preventing data type overflows. Default: NULL.}
}
\description{
Cumsum
}
\section{cumsum(input, dim, out=NULL, dtype=NULL) -> Tensor }{


Returns the cumulative sum of elements of \code{input} in the dimension
\code{dim}.

For example, if \code{input} is a vector of size N, the result will also be
a vector of size N, with elements.

\deqn{
    y_i = x_1 + x_2 + x_3 + \dots + x_i
}
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(10))
a
torch_cumsum(a, dim=1)
}
}
