% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_clamp}
\alias{torch_clamp}
\title{Clamp}
\usage{
torch_clamp(self, min = NULL, max = NULL)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{min}{(Number) lower-bound of the range to be clamped to}

\item{max}{(Number) upper-bound of the range to be clamped to}
}
\description{
Clamp
}
\section{clamp(input, min, max, out=NULL) -> Tensor }{


Clamp all elements in \code{input} into the range \code{[} \code{min}, \code{max} \verb{]} and return
a resulting tensor:

\deqn{
    y_i = \left\{ \begin{array}{ll}
        \mbox{min} & \mbox{if } x_i < \mbox{min} \\
        x_i & \mbox{if } \mbox{min} \leq x_i \leq \mbox{max} \\
        \mbox{max} & \mbox{if } x_i > \mbox{max}
    \end{array}
    \right.
}
If \code{input} is of type \code{FloatTensor} or \code{DoubleTensor}, args \code{min}
and \code{max} must be real numbers, otherwise they should be integers.
}

\section{clamp(input, *, min, out=NULL) -> Tensor }{


Clamps all elements in \code{input} to be larger or equal \code{min}.

If \code{input} is of type \code{FloatTensor} or \code{DoubleTensor}, \code{value}
should be a real number, otherwise it should be an integer.
}

\section{clamp(input, *, max, out=NULL) -> Tensor }{


Clamps all elements in \code{input} to be smaller or equal \code{max}.

If \code{input} is of type \code{FloatTensor} or \code{DoubleTensor}, \code{value}
should be a real number, otherwise it should be an integer.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(4))
a
torch_clamp(a, min=-0.5, max=0.5)


a = torch_randn(c(4))
a
torch_clamp(a, min=0.5)


a = torch_randn(c(4))
a
torch_clamp(a, max=0.5)
}
}
