% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-activation.R
\name{nnf_selu}
\alias{nnf_selu}
\alias{nnf_selu_}
\title{Selu}
\usage{
nnf_selu(input, inplace = FALSE)

nnf_selu_(input)
}
\arguments{
\item{input}{(N,*) tensor, where * means, any number of additional
dimensions}

\item{inplace}{can optionally do the operation in-place. Default: FALSE}
}
\description{
Applies element-wise,
\deqn{SELU(x) = scale * (max(0,x) + min(0, \alpha * (exp(x) - 1)))},
with \eqn{\alpha=1.6732632423543772848170429916717} and
\eqn{scale=1.0507009873554804934193349852946}.
}
\examples{
if (torch_is_installed()) {
x <- torch_randn(2, 2)
y <- nnf_selu(x)
nnf_selu_(x)
torch_equal(x, y)
}
}
