% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-activation.R
\name{nnf_hardswish}
\alias{nnf_hardswish}
\title{Hardswish}
\usage{
nnf_hardswish(input, inplace = FALSE)
}
\arguments{
\item{input}{(N,*) tensor, where * means, any number of additional
dimensions}

\item{inplace}{can optionally do the operation in-place. Default: FALSE}
}
\description{
Applies the hardswish function, element-wise, as described in the paper:
Searching for MobileNetV3.
}
\details{
\deqn{ \mbox{Hardswish}(x) = \left\{
  \begin{array}{ll}
  0 & \mbox{if } x \le -3, \\
  x & \mbox{if } x \ge +3, \\
  x \cdot (x + 3)/6 & \mbox{otherwise}
  \end{array}
  \right. }
}
