% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-linear.R
\name{nnf_bilinear}
\alias{nnf_bilinear}
\title{Bilinear}
\usage{
nnf_bilinear(input1, input2, weight, bias = NULL)
}
\arguments{
\item{input1}{\eqn{(N, *, H_{in1})} where \eqn{H_{in1}=\mbox{in1\_features}}
and \eqn{*} means any number of additional dimensions.
All but the last dimension of the inputs should be the same.}

\item{input2}{\eqn{(N, *, H_{in2})} where \eqn{H_{in2}=\mbox{in2\_features}}}

\item{weight}{\eqn{(\mbox{out\_features}, \mbox{in1\_features},
\mbox{in2\_features})}}

\item{bias}{\eqn{(\mbox{out\_features})}}
}
\value{
output \eqn{(N, *, H_{out})} where \eqn{H_{out}=\mbox{out\_features}}
and all but the last dimension are the same shape as the input.
}
\description{
Applies a bilinear transformation to the incoming data:
\eqn{y = x_1 A x_2 + b}
}
