% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-pooling.R
\name{nn_adaptive_max_pool1d}
\alias{nn_adaptive_max_pool1d}
\title{Applies a 1D adaptive max pooling over an input signal composed of several input planes.}
\usage{
nn_adaptive_max_pool1d(output_size, return_indices = FALSE)
}
\arguments{
\item{output_size}{the target output size H}

\item{return_indices}{if \code{TRUE}, will return the indices along with the outputs.
Useful to pass to \code{\link[=nn_max_unpool1d]{nn_max_unpool1d()}}. Default: \code{FALSE}}
}
\description{
The output size is H, for any input size.
The number of output features is equal to the number of input planes.
}
\examples{
if (torch_is_installed()) {
# target output size of 5
m <- nn_adaptive_max_pool1d(5)
input <- torch_randn(1, 64, 8)
output <- m(input)
}
}
