% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autograd.R
\name{autograd_function}
\alias{autograd_function}
\title{Records operation history and defines formulas for differentiating ops.}
\usage{
autograd_function(forward, backward)
}
\arguments{
\item{forward}{Performs the operation. It must accept a context \code{ctx} as the first argument,
followed by any number of arguments (tensors or other types). The context can be
used to store tensors that can be then retrieved during the backward pass.
See \link{AutogradContext} for more information about context methods.}

\item{backward}{Defines a formula for differentiating the operation. It must accept
a context \code{ctx} as the first argument, followed by as many outputs did \code{forward()}
return, and it should return a named list. Each argument is the gradient w.r.t
the given output, and each element in the returned list should be the gradient
w.r.t. the corresponding input. The context can be used to retrieve tensors saved
during the forward pass. It also has an attribute \code{ctx$needs_input_grad} as a
named list of booleans representing whether each input needs gradient.
E.g., \code{backward()} will have \code{ctx$needs_input_grad$input = TRUE} if the \code{input}
argument to \code{forward()} needs gradient computated w.r.t. the output.
See \link{AutogradContext} for more information about context methods.}
}
\description{
Every operation performed on Tensor's creates a new function object, that
performs the computation, and records that it happened. The history is
retained in the form of a DAG of functions, with edges denoting data
dependencies (input <- output). Then, when backward is called, the graph is
processed in the topological ordering, by calling \code{backward()} methods of each
Function object, and passing returned gradients on to next Function's.
}
\examples{
if (torch_is_installed()) {

exp2 <- autograd_function(
  forward = function(ctx, i) {
    result <- i$exp()
    ctx$save_for_backward(result = result)
    result
  },
  backward = function(ctx, grad_output) {
    list(i = grad_output * ctx$saved_variable$result)
  }
)
}
}
