% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creation-ops.R, R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_ones_like}
\alias{torch_ones_like}
\title{Ones_like}
\usage{
torch_ones_like(
  input,
  dtype = NULL,
  layout = torch_strided(),
  device = NULL,
  requires_grad = FALSE,
  memory_format = torch_preserve_format()
)
}
\arguments{
\item{input}{(Tensor) the size of \code{input} will determine size of the output tensor.}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned Tensor.        Default: if \code{NULL}, defaults to the dtype of \code{input}.}

\item{layout}{(\code{torch.layout}, optional) the desired layout of returned tensor.        Default: if \code{NULL}, defaults to the layout of \code{input}.}

\item{device}{(\code{torch.device}, optional) the desired device of returned tensor.        Default: if \code{NULL}, defaults to the device of \code{input}.}

\item{requires_grad}{(bool, optional) If autograd should record operations on the        returned tensor. Default: \code{FALSE}.}

\item{memory_format}{(\code{torch.memory_format}, optional) the desired memory format of        returned Tensor. Default: \code{torch_preserve_format}.}
}
\description{
Ones_like
}
\section{ones_like(input, dtype=NULL, layout=NULL, device=NULL, requires_grad=False, memory_format=torch.preserve_format) -> Tensor }{


Returns a tensor filled with the scalar value \code{1}, with the same size as
\code{input}. \code{torch_ones_like(input)} is equivalent to
\code{torch_ones(input.size(), dtype=input.dtype, layout=input.layout, device=input.device)}.
}

\section{Warning}{

As of 0.4, this function does not support an \code{out} keyword. As an alternative,
the old \code{torch_ones_like(input, out=output)} is equivalent to
\code{torch_ones(input.size(), out=output)}.
}

\examples{
if (torch_is_installed()) {

input = torch_empty(c(2, 3))
torch_ones_like(input)
}
}
