% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_elu}
\alias{nn_elu}
\title{ELU module}
\usage{
nn_elu(alpha = 1, inplace = FALSE)
}
\arguments{
\item{alpha}{the \eqn{\alpha} value for the ELU formulation. Default: 1.0}

\item{inplace}{can optionally do the operation in-place. Default: \code{FALSE}}
}
\description{
Applies the element-wise function:
}
\details{
\deqn{
  \mbox{ELU}(x) = \max(0,x) + \min(0, \alpha * (\exp(x) - 1))
}
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(N, *)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_elu()
input <- torch_randn(2)
output <- m(input)
}
}
