% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_pdist}
\alias{torch_pdist}
\title{Pdist}
\usage{
torch_pdist(self, p = 2L)
}
\arguments{
\item{self}{NA input tensor of shape \eqn{N \times M}.}

\item{p}{NA p value for the p-norm distance to calculate between each vector pair        \eqn{\in [0, \infty]}.}
}
\description{
Pdist
}
\section{pdist(input, p=2) -> Tensor }{


Computes the p-norm distance between every pair of row vectors in the input.
This is identical to the upper triangular portion, excluding the diagonal, of
\verb{torch_norm(input[:, NULL] - input, dim=2, p=p)}. This function will be faster
if the rows are contiguous.

If input has shape \eqn{N \times M} then the output will have shape
\eqn{\frac{1}{2} N (N - 1)}.

This function is equivalent to \code{scipy.spatial.distance.pdist(input, 'minkowski', p=p)} if \eqn{p \in (0, \infty)}. When \eqn{p = 0} it is
equivalent to \code{scipy.spatial.distance.pdist(input, 'hamming') * M}.
When \eqn{p = \infty}, the closest scipy function is
\verb{scipy.spatial.distance.pdist(xn, lambda x, y: np.abs(x - y).max())}.
}

