% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_add}
\alias{torch_add}
\title{Add}
\usage{
torch_add(self, other, alpha = 1L)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{other}{(Tensor/Number) the second input tensor/number.}

\item{alpha}{(Number) the scalar multiplier for \code{other}}
}
\description{
Add
}
\section{add(input, other, out=NULL) }{


Adds the scalar \code{other} to each element of the input \code{input}
and returns a new resulting tensor.

\deqn{
    \mbox{out} = \mbox{input} + \mbox{other}
}
If \code{input} is of type FloatTensor or DoubleTensor, \code{other} must be
a real number, otherwise it should be an integer.
}

\section{add(input, other, *, alpha=1, out=NULL) }{


Each element of the tensor \code{other} is multiplied by the scalar
\code{alpha} and added to each element of the tensor \code{input}.
The resulting tensor is returned.

The shapes of \code{input} and \code{other} must be
broadcastable .

\deqn{
    \mbox{out} = \mbox{input} + \mbox{alpha} \times \mbox{other}
}
If \code{other} is of type FloatTensor or DoubleTensor, \code{alpha} must be
a real number, otherwise it should be an integer.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(4))
a
torch_add(a, 20)


a = torch_randn(c(4))
a
b = torch_randn(c(4, 1))
b
torch_add(a, b)
}
}
