% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-vision.R
\name{nnf_affine_grid}
\alias{nnf_affine_grid}
\title{Affine_grid}
\usage{
nnf_affine_grid(theta, size, align_corners = FALSE)
}
\arguments{
\item{theta}{(Tensor) input batch of affine matrices with shape
(\eqn{N \times 2 \times 3}) for 2D or  (\eqn{N \times 3 \times 4}) for 3D}

\item{size}{(torch.Size) the target output image size. (\eqn{N \times C \times H \times W}
for 2D or \eqn{N \times C \times D \times H \times W} for 3D)
Example: torch.Size((32, 3, 24, 24))}

\item{align_corners}{(bool, optional) if \code{True}, consider \code{-1} and \code{1}
to refer to the centers of the corner pixels rather than the image corners.
Refer to \code{\link[=nnf_grid_sample]{nnf_grid_sample()}} for a more complete description. A grid generated by
\code{\link[=nnf_affine_grid]{nnf_affine_grid()}} should be passed to \code{\link[=nnf_grid_sample]{nnf_grid_sample()}}  with the same setting for
this option. Default: \code{False}}
}
\description{
Generates a 2D or 3D flow field (sampling grid), given a batch of
affine matrices \code{theta}.
}
\section{Note}{


This function is often used in conjunction with \code{\link[=nnf_grid_sample]{nnf_grid_sample()}}
to build \verb{Spatial Transformer Networks}_ .
}

