% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_multilabel_soft_margin_loss}
\alias{nn_multilabel_soft_margin_loss}
\title{Multi label soft margin loss}
\usage{
nn_multilabel_soft_margin_loss(weight = NULL, reduction = "mean")
}
\arguments{
\item{weight}{(Tensor, optional): a manual rescaling weight given to each
class. If given, it has to be a Tensor of size \code{C}. Otherwise, it is
treated as if having all ones.}

\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'mean'} | \code{'sum'}. \code{'none'}: no reduction will be applied,
\code{'mean'}: the sum of the output will be divided by the number of
elements in the output, \code{'sum'}: the output will be summed. Note: \code{size_average}
and \code{reduce} are in the process of being deprecated, and in the meantime,
specifying either of those two args will override \code{reduction}. Default: \code{'mean'}}
}
\description{
Creates a criterion that optimizes a multi-label one-versus-all
loss based on max-entropy, between input \eqn{x} and target \eqn{y} of size
\eqn{(N, C)}.
}
\details{
For each sample in the minibatch:

\deqn{
  loss(x, y) = - \frac{1}{C} * \sum_i y[i] * \log((1 + \exp(-x[i]))^{-1})
+ (1-y[i]) * \log\left(\frac{\exp(-x[i])}{(1 + \exp(-x[i]))}\right)
}

where \eqn{i \in \left\{0, \; \cdots , \; \mbox{x.nElement}() - 1\right\}},
\eqn{y[i] \in \left\{0, \; 1\right\}}.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, C)} where \code{N} is the batch size and \code{C} is the number of classes.
\item Target: \eqn{(N, C)}, label targets padded by -1 ensuring same shape as the input.
\item Output: scalar. If \code{reduction} is \code{'none'}, then \eqn{(N)}.
}
}

