% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_hardswish}
\alias{nn_hardswish}
\title{Hardswish module}
\usage{
nn_hardswish()
}
\description{
Applies the hardswish function, element-wise, as described in the paper:
\href{https://arxiv.org/abs/1905.02244}{Searching for MobileNetV3}
}
\details{
\deqn{ \mbox{Hardswish}(x) = \left\{
  \begin{array}{ll}
  0 & \mbox{if } x \le -3, \\
  x & \mbox{if } x \ge +3, \\
  x \cdot (x + 3)/6 & \mbox{otherwise}
  \end{array}
  \right. }
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(N, *)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
\dontrun{
m <- nn_hardswish()
input <- torch_randn(2)
output <- m(input)
}

}
}
