% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-embedding.R
\name{nnf_embedding_bag}
\alias{nnf_embedding_bag}
\title{Embedding_bag}
\usage{
nnf_embedding_bag(
  input,
  weight,
  offsets = NULL,
  max_norm = NULL,
  norm_type = 2,
  scale_grad_by_freq = FALSE,
  mode = "mean",
  sparse = FALSE,
  per_sample_weights = NULL,
  include_last_offset = FALSE
)
}
\arguments{
\item{input}{(LongTensor) Tensor containing bags of indices into the embedding matrix}

\item{weight}{(Tensor) The embedding matrix with number of rows equal to the
maximum possible index + 1, and number of columns equal to the embedding size}

\item{offsets}{(LongTensor, optional) Only used when \code{input} is 1D. \code{offsets}
determines the starting index position of each bag (sequence) in \code{input}.}

\item{max_norm}{(float, optional) If given, each embedding vector with norm
larger than \code{max_norm} is renormalized to have norm \code{max_norm}.
Note: this will modify \code{weight} in-place.}

\item{norm_type}{(float, optional) The \code{p} in the \code{p}-norm to compute for the
\code{max_norm} option. Default \code{2}.}

\item{scale_grad_by_freq}{(boolean, optional) if given, this will scale gradients
by the inverse of frequency of the words in the mini-batch. Default \code{FALSE}.                                            Note: this option is not supported when \code{mode="max"}.}

\item{mode}{(string, optional) \code{"sum"}, \code{"mean"} or \code{"max"}. Specifies
the way to reduce the bag. Default: 'mean'}

\item{sparse}{(bool, optional) if \code{TRUE}, gradient w.r.t. \code{weight} will be a
sparse tensor. See Notes under \code{nn_embedding} for more details regarding
sparse gradients. Note: this option is not supported when \code{mode="max"}.}

\item{per_sample_weights}{(Tensor, optional) a tensor of float / double weights,
or NULL to indicate all weights should be taken to be 1. If specified,
\code{per_sample_weights} must have exactly the same shape as input and is treated
as having the same \code{offsets}, if those are not \code{NULL}.}

\item{include_last_offset}{(bool, optional) if \code{TRUE}, the size of offsets is
equal to the number of bags + 1.}
}
\description{
Computes sums, means or maxes of \code{bags} of embeddings, without instantiating the
intermediate embeddings.
}
