% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-utils-weight-norm.R
\name{nn_utils_weight_norm}
\alias{nn_utils_weight_norm}
\title{nn_utils_weight_norm}
\value{
The original module with the weight_v and weight_g paramters.
}
\description{
Applies weight normalization to a parameter in the given module.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{    \eqn{\mathbf{w} = g \dfrac{\mathbf{v}}{\|\mathbf{v}\|}}
}\if{html}{\out{</div>}}

Weight normalization is a reparameterization that decouples the magnitude
of a weight tensor from its direction. This replaces the parameter specified
by \code{name}  (e.g. \code{'weight'}) with two parameters: one specifying the
magnitude (e.g. \code{'weight_g'}) and one specifying the direction
(e.g. \code{'weight_v'}).
}
\note{
The pytorch Weight normalization is implemented via a hook that recomputes
the weight tensor from the magnitude and direction before every \code{forward()}
call. Since torch for R still do not support hooks, the weight recomputation
need to be done explicitly inside the \code{forward()} definition trough a call of
the \code{recompute()} method. See examples.

By default, with \code{dim = 0}, the norm is computed independently per output
channel/plane. To compute a norm over the entire weight tensor, use
\code{dim = NULL}.

@references https://arxiv.org/abs/1602.07868
}
\examples{
if (torch_is_installed()) {
x = nn_linear(in_features = 20, out_features = 40)
weight_norm = nn_utils_weight_norm$new(name = 'weight', dim = 2)
weight_norm$apply(x)
x$weight_g$size()
x$weight_v$size()
x$weight

# the recompute() method recomputes the weight using g and v. It must be called
# explicitly inside `forward()`.
weight_norm$recompute(x)

}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-nn_utils_weight_norm-new}{\code{nn_utils_weight_norm$new()}}
\item \href{#method-nn_utils_weight_norm-compute_weight}{\code{nn_utils_weight_norm$compute_weight()}}
\item \href{#method-nn_utils_weight_norm-apply}{\code{nn_utils_weight_norm$apply()}}
\item \href{#method-nn_utils_weight_norm-call}{\code{nn_utils_weight_norm$call()}}
\item \href{#method-nn_utils_weight_norm-recompute}{\code{nn_utils_weight_norm$recompute()}}
\item \href{#method-nn_utils_weight_norm-remove}{\code{nn_utils_weight_norm$remove()}}
\item \href{#method-nn_utils_weight_norm-clone}{\code{nn_utils_weight_norm$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nn_utils_weight_norm-new"></a>}}
\if{latex}{\out{\hypertarget{method-nn_utils_weight_norm-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{nn_utils_weight_norm$new(name, dim)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(str, optional): name of weight parameter}

\item{\code{dim}}{(int, optional): dimension over which to compute the norm}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nn_utils_weight_norm-compute_weight"></a>}}
\if{latex}{\out{\hypertarget{method-nn_utils_weight_norm-compute_weight}{}}}
\subsection{Method \code{compute_weight()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{nn_utils_weight_norm$compute_weight(module, name = NULL, dim = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{module}}{(Module): containing module}

\item{\code{name}}{(str, optional): name of weight parameter}

\item{\code{dim}}{(int, optional): dimension over which to compute the norm}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nn_utils_weight_norm-apply"></a>}}
\if{latex}{\out{\hypertarget{method-nn_utils_weight_norm-apply}{}}}
\subsection{Method \code{apply()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{nn_utils_weight_norm$apply(module, name = NULL, dim = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{module}}{(Module): containing module}

\item{\code{name}}{(str, optional): name of weight parameter}

\item{\code{dim}}{(int, optional): dimension over which to compute the norm}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nn_utils_weight_norm-call"></a>}}
\if{latex}{\out{\hypertarget{method-nn_utils_weight_norm-call}{}}}
\subsection{Method \code{call()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{nn_utils_weight_norm$call(module)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{module}}{(Module): containing module}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nn_utils_weight_norm-recompute"></a>}}
\if{latex}{\out{\hypertarget{method-nn_utils_weight_norm-recompute}{}}}
\subsection{Method \code{recompute()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{nn_utils_weight_norm$recompute(module)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{module}}{(Module): containing module}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nn_utils_weight_norm-remove"></a>}}
\if{latex}{\out{\hypertarget{method-nn_utils_weight_norm-remove}{}}}
\subsection{Method \code{remove()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{nn_utils_weight_norm$remove(module, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{module}}{(Module): containing module}

\item{\code{name}}{(str, optional): name of weight parameter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nn_utils_weight_norm-clone"></a>}}
\if{latex}{\out{\hypertarget{method-nn_utils_weight_norm-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{nn_utils_weight_norm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
