% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/wrapers.R
\name{torch_hamming_window}
\alias{torch_hamming_window}
\title{Hamming_window}
\usage{
torch_hamming_window(
  window_length,
  periodic = TRUE,
  alpha = 0.54,
  beta = 0.46,
  dtype = NULL,
  layout = NULL,
  device = NULL,
  requires_grad = FALSE
)
}
\arguments{
\item{window_length}{(int) the size of returned window}

\item{periodic}{(bool, optional) If TRUE, returns a window to be used as periodic        function. If False, return a symmetric window.}

\item{alpha}{(float, optional) The coefficient \eqn{\alpha} in the equation above}

\item{beta}{(float, optional) The coefficient \eqn{\beta} in the equation above}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned tensor.        Default: if \code{NULL}, uses a global default (see \code{torch_set_default_tensor_type}). Only floating point types are supported.}

\item{layout}{(\code{torch.layout}, optional) the desired layout of returned window tensor. Only          \code{torch_strided} (dense layout) is supported.}

\item{device}{(\code{torch.device}, optional) the desired device of returned tensor.        Default: if \code{NULL}, uses the current device for the default tensor type        (see \code{torch_set_default_tensor_type}). \code{device} will be the CPU        for CPU tensor types and the current CUDA device for CUDA tensor types.}

\item{requires_grad}{(bool, optional) If autograd should record operations on the        returned tensor. Default: \code{FALSE}.}
}
\description{
Hamming_window
}
\note{
\if{html}{\out{<div class="sourceCode">}}\preformatted{If `window_length` \eqn{=1}, the returned window contains a single value 1.
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{This is a generalized version of `torch_hann_window`.
}\if{html}{\out{</div>}}
}
\section{hamming_window(window_length, periodic=TRUE, alpha=0.54, beta=0.46, dtype=NULL, layout=torch.strided, device=NULL, requires_grad=False) -> Tensor }{


Hamming window function.

\deqn{
    w[n] = \alpha - \beta\ \cos \left( \frac{2 \pi n}{N - 1} \right),
}
where \eqn{N} is the full window size.

The input \code{window_length} is a positive integer controlling the
returned window size. \code{periodic} flag determines whether the returned
window trims off the last duplicate value from the symmetric window and is
ready to be used as a periodic window with functions like
\code{torch_stft}. Therefore, if \code{periodic} is true, the \eqn{N} in
above formula is in fact \eqn{\mbox{window\_length} + 1}. Also, we always have
\code{torch_hamming_window(L, periodic=TRUE)} equal to
\verb{torch_hamming_window(L + 1, periodic=False)[:-1])}.
}

