% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_topk}
\alias{torch_topk}
\title{Topk}
\usage{
torch_topk(self, k, dim = -1L, largest = TRUE, sorted = TRUE)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{k}{(int) the k in "top-k"}

\item{dim}{(int, optional) the dimension to sort along}

\item{largest}{(bool, optional) controls whether to return largest or           smallest elements}

\item{sorted}{(bool, optional) controls whether to return the elements           in sorted order}
}
\description{
Topk
}
\section{topk(input, k, dim=NULL, largest=TRUE, sorted=TRUE) -> (Tensor, LongTensor) }{


Returns the \code{k} largest elements of the given \code{input} tensor along
a given dimension.

If \code{dim} is not given, the last dimension of the \code{input} is chosen.

If \code{largest} is \code{FALSE} then the \code{k} smallest elements are returned.

A namedtuple of \verb{(values, indices)} is returned, where the \code{indices} are the indices
of the elements in the original \code{input} tensor.

The boolean option \code{sorted} if \code{TRUE}, will make sure that the returned
\code{k} elements are themselves sorted
}

\examples{
if (torch_is_installed()) {

x = torch_arange(1., 6.)
x
torch_topk(x, 3)
}
}
