% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_argmin}
\alias{torch_argmin}
\title{Argmin}
\usage{
torch_argmin(self, dim = NULL, keepdim = FALSE)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim}{(int) the dimension to reduce. If \code{NULL}, the argmin of the flattened input is returned.}

\item{keepdim}{(bool) whether the output tensor has \code{dim} retained or not. Ignored if \code{dim=NULL}.}
}
\description{
Argmin
}
\section{argmin(input) -> LongTensor }{


Returns the indices of the minimum value of all elements in the \code{input} tensor.

This is the second value returned by \code{torch_min}. See its
documentation for the exact semantics of this method.
}

\section{argmin(input, dim, keepdim=False, out=NULL) -> LongTensor }{


Returns the indices of the minimum values of a tensor across a dimension.

This is the second value returned by \code{torch_min}. See its
documentation for the exact semantics of this method.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(4, 4))
a
torch_argmin(a)


a = torch_randn(c(4, 4))
a
torch_argmin(a, dim=1)
}
}
