% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-loss.R
\name{nnf_cross_entropy}
\alias{nnf_cross_entropy}
\title{Cross_entropy}
\usage{
nnf_cross_entropy(
  input,
  target,
  weight = NULL,
  ignore_index = -100,
  reduction = c("mean", "sum", "none")
)
}
\arguments{
\item{input}{(Tensor) \eqn{(N, C)} where \verb{C = number of classes} or \eqn{(N, C, H, W)}
in case of 2D Loss, or \eqn{(N, C, d_1, d_2, ..., d_K)} where \eqn{K \geq 1}
in the case of K-dimensional loss.}

\item{target}{(Tensor) \eqn{(N)} where each value is \eqn{0 \leq \mbox{targets}[i] \leq C-1},
or \eqn{(N, d_1, d_2, ..., d_K)} where \eqn{K \geq 1} for K-dimensional loss.}

\item{weight}{(Tensor, optional) a manual rescaling weight given to each class. If
given, has to be a Tensor of size \code{C}}

\item{ignore_index}{(int, optional) Specifies a target value that is ignored
and does not contribute to the input gradient.}

\item{reduction}{(string, optional) – Specifies the reduction to apply to the
output: 'none' | 'mean' | 'sum'. 'none': no reduction will be applied, 'mean':
the sum of the output will be divided by the number of elements in the output,
'sum': the output will be summed. Default: 'mean'}
}
\description{
This criterion combines \code{log_softmax} and \code{nll_loss} in a single
function.
}
