% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_fft}
\alias{torch_fft}
\title{Fft}
\usage{
torch_fft(self, signal_ndim, normalized = FALSE)
}
\arguments{
\item{self}{(Tensor) the input tensor of at least \code{signal_ndim} \code{+ 1}        dimensions}

\item{signal_ndim}{(int) the number of dimensions in each signal.        \code{signal_ndim} can only be 1, 2 or 3}

\item{normalized}{(bool, optional) controls whether to return normalized results.        Default: \code{FALSE}}
}
\description{
Fft
}
\note{
\preformatted{For CUDA tensors, an LRU cache is used for cuFFT plans to speed up
repeatedly running FFT methods on tensors of same geometry with same
configuration. See cufft-plan-cache for more details on how to
monitor and control the cache.
}
}
\section{fft(input, signal_ndim, normalized=False) -> Tensor }{


Complex-to-complex Discrete Fourier Transform

This method computes the complex-to-complex discrete Fourier transform.
Ignoring the batch dimensions, it computes the following expression:

\deqn{
    X[\omega_1, \dots, \omega_d] =
        \sum_{n_1=0}^{N_1-1} \dots \sum_{n_d=0}^{N_d-1} x[n_1, \dots, n_d]
         e^{-j\ 2 \pi \sum_{i=0}^d \frac{\omega_i n_i}{N_i}},
}
where \eqn{d} = \code{signal_ndim} is number of dimensions for the
signal, and \eqn{N_i} is the size of signal dimension \eqn{i}.

This method supports 1D, 2D and 3D complex-to-complex transforms, indicated
by \code{signal_ndim}. \code{input} must be a tensor with last dimension
of size 2, representing the real and imaginary components of complex
numbers, and should have at least \code{signal_ndim + 1} dimensions with optionally
arbitrary number of leading batch dimensions. If \code{normalized} is set to
\code{TRUE}, this normalizes the result by dividing it with
\eqn{\sqrt{\prod_{i=1}^K N_i}} so that the operator is unitary.

Returns the real and the imaginary parts together as one tensor of the same
shape of \code{input}.

The inverse of this function is \code{\link{torch_ifft}}.
}

\section{Warning}{

For CPU tensors, this method is currently only available with MKL. Use
\code{torch_backends.mkl.is_available} to check if MKL is installed.
}

\examples{
if (torch_is_installed()) {

# unbatched 2D FFT
x = torch_randn(c(4, 3, 2))
torch_fft(x, 2)
# batched 1D FFT
torch_fft(x, 1)
# arbitrary number of batch dimensions, 2D FFT
x = torch_randn(c(3, 3, 5, 5, 2))
torch_fft(x, 2)

}
}
