% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_div}
\alias{torch_div}
\title{Div}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{other}{(Number) the number to be divided to each element of \code{input}}
}
\description{
Div
}
\section{div(input, other, out=None) -> Tensor }{


Divides each element of the input \code{input} with the scalar \code{other} and
returns a new resulting tensor.



Each element of the tensor \code{input} is divided by each element of the tensor
\code{other}. The resulting tensor is returned.

\deqn{
    \mbox{out}_i = \frac{\mbox{input}_i}{\mbox{other}_i}
}
The shapes of \code{input} and \code{other} must be broadcastable
. If the \code{torch_dtype} of \code{input} and
\code{other} differ, the \code{torch_dtype} of the result tensor is determined
following rules described in the type promotion documentation
. If \code{out} is specified, the result must be
castable  to the \code{torch_dtype} of the
specified output tensor. Integral division by zero leads to undefined behavior.
}

\section{Warning}{

Integer division using div is deprecated, and in a future release div will
perform true division like \code{\link{torch_true_divide}}.
Use \code{\link{torch_floor_divide}} (// in Python) to perform integer division,
instead.

\deqn{
    \mbox{out}_i = \frac{\mbox{input}_i}{\mbox{other}}
}
If the \code{torch_dtype} of \code{input} and \code{other} differ, the
\code{torch_dtype} of the result tensor is determined following rules
described in the type promotion documentation . If
\code{out} is specified, the result must be castable
to the \code{torch_dtype} of the specified output tensor. Integral division
by zero leads to undefined behavior.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(5))
a
torch_div(a, 0.5)


a = torch_randn(c(4, 4))
a
b = torch_randn(c(4))
b
torch_div(a, b)
}
}
